<?php
/**
 * @package Featured_Videos
 * @version 1.6
 */
/*
Plugin Name: Featured Videos
Plugin URI: http://wpmu.org
Description: Replace featured image with a video if video fo the same name exists
Version: 1.0
Author URI: http://wpmu.org
*/

// check for video versions of featured image

function vfi_post_thumbnail_html( $html , $post_id , $post_thumbnail_id , $size , $attr ) {
	
	global $is_chrome;
	
	if ( !is_singular() ) return $html;
	
	/* get the basic url, width and height of the featured image */
	$fi_attr = wp_get_attachment_image_src ( $post_thumbnail_id , $size);
	
	/* get the original url - we need this to search for the video */	
	$fi_url = wp_get_attachment_url ( $post_thumbnail_id );
	
	/* work out the name */
	$fi_url_exploded = explode( '/' , $fi_url );
	$fi_name = $fi_url_exploded[ count( $fi_url_exploded ) - 1 ];
	$fi_name_exploded = explode( '.' , $fi_name );

	/* now search the medial library for any matches */
	$args = array( 'post_type' => 'attachment' , 'post_status' => 'inherit' ,
				'meta_query' => array(
					array(
						'key' => '_wp_attached_file',
						'value' => $fi_name_exploded[0] . '.',
						'compare' => 'LIKE'
					)
				));
				
	$query = new WP_Query( $args );
	
	$found = count( $query->posts );
	
	/* Will always find featured image so we need more than one match */
	if ($found > 1) {
	
		$new_html = '';
		
		/* loop through the matches and process those with a video mime type */	
		foreach( $query->posts AS $attach ){
		
			if ( substr( $attach->post_mime_type , 0 , 5 ) == 'video' ) {
		
				if ( $new_html == '') {
				
					$controls = ( $is_chrome == true ) ? 'controls' : '';
				
					$new_html = '<video width="'. $fi_attr[1] . '" class="featured" ' . $controls . ' autoplay preload loop poster="' . $fi_attr[0] . '">';
				}
				
				$new_html .= '<source class="' . $sourceclass . '" src="' . $attach->guid . '" type="' . $attach->post_mime_type . '">';
			
			} 	

		}
		
		/* if video files were found then update the html */
		if ( $new_html != '' ) $html = $new_html . $html . '</video>';
		
	}

	return $html;
}

add_filter ( 'post_thumbnail_html' , 'vfi_post_thumbnail_html' , 10 , 5);